﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public partial class Administration : BaseComponent
    {
        /// <summary>
        /// panele adminsitracyjne na poszczegolne rodzaje aktywnosci
        /// </summary>
        private Dictionary<AdministrationAreaType, AdminPanel> _adminPanelDictionary = new Dictionary<AdministrationAreaType, AdminPanel>();


        public Administration(Gemini.Core.WebApplication.Interface.IWebPageComponentParam WebPageComponentParam)
            : base(WebPageComponentParam) 
        {
            // rejestracja paneli adminsitracyjnych
            _adminPanelDictionary.Add(AdministrationAreaType.None, new NonePanel(this));
            _adminPanelDictionary.Add(AdministrationAreaType.ClassList, new ClassListPanel(this));
            _adminPanelDictionary.Add(AdministrationAreaType.ClassEdit, new ClassEditBasePanel(this));
            _adminPanelDictionary.Add(AdministrationAreaType.ClassEditNote, new ClassEditNotePanel(this));
            _adminPanelDictionary.Add(AdministrationAreaType.ClassEditStudent, new ClassEditStudentPanel(this));
            _adminPanelDictionary.Add(AdministrationAreaType.ClassEditCompetences, new ClassEditCompetencesPanel(this));
            _adminPanelDictionary.Add(AdministrationAreaType.StudentList, new StudentListPanel(this));
            _adminPanelDictionary.Add(AdministrationAreaType.StudentEdit, new StudentEditPanel(this));
            _adminPanelDictionary.Add(AdministrationAreaType.StudentEditCompetences, new StudentEditCompetencesPanel(this));            
        }

        /// <summary>
        /// Rodzaje paneli adminsitracyjnych
        /// </summary>
        public enum AdministrationAreaType
        {
            /// <summary>
            /// Nie zostal odczytany
            /// </summary>
            NotLoaded = -1,
            /// <summary>
            /// Brak panelu
            /// </summary>
            None = 0,
            /// <summary>
            /// Lista klas
            /// </summary>
            ClassList = 10,
            /// <summary>
            /// Edycja danych klasy
            /// </summary>
            ClassEdit = 11,
            /// <summary>
            /// Edycja danych klasy - ocena
            /// </summary>
            ClassEditNote = 12,
            /// <summary>
            /// Edycja danych klasy - pracownicy
            /// </summary>
            ClassEditStudent = 13,
            /// <summary>
            /// Edycja danych klasy - plan nauczania
            /// </summary>
            ClassEditCompetences = 14,
            /// <summary>
            /// Lista studentow
            /// </summary>
            StudentList = 20,
            /// <summary>
            /// Edycja studenta
            /// </summary>
            StudentEdit = 21,
            /// <summary>
            /// Plan naucznania dla studenta umozliwiajacy resetowanie kompetencji skladowych
            /// </summary>
            StudentEditCompetences = 22,
            /// <summary>
            /// eduFarma
            /// </summary>
            eduFarma = 99,
        }

        private AdministrationAreaType _administrationArea = AdministrationAreaType.NotLoaded;
        protected AdministrationAreaType AdministrationArea
        {
            get
            {
                if (_administrationArea == AdministrationAreaType.NotLoaded)
                {
                    _administrationArea = AdministrationAreaType.None;
                    string _area = Environment.GetRequestParamString("area");
                    if (!string.IsNullOrEmpty(_area))
                    {
                        try
                        {
                            _administrationArea = (AdministrationAreaType)Enum.Parse(typeof(AdministrationAreaType), _area, true);
                        }
                        catch { }
                    }
                }
                return _administrationArea;
            }
            set
            {
                _administrationArea = value;
            }
        }

        private BL.BO.Instructor _instructor = null;
        public BL.BO.Instructor Instructor
        {
            get
            {
                if (_instructor == null)
                {
                    _instructor = BLELearning.Instructor.RestoreByUser(Environment.User);
                }
                return _instructor;
            }
        }

        public override bool Save()
        {
            if (WebPageEngine.IsUserAuthorized)
            {
                if (_adminPanelDictionary.ContainsKey(AdministrationArea))
                {
                    _adminPanelDictionary[AdministrationArea].Save();
                }
            }
            return true;
        }

        public override void Load()
        {
            #region Config
            XML.Element.Start("Config");
            XML.Element.Attribute("IUA", WebPageEngine.IsUserAuthorized ? "1" : "0");
            XML.Element.Attribute("AdministrationAreaValue", AdministrationArea.ToString());
            XML.Element.Attribute("AdministrationArea", (int)AdministrationArea);
            if (Environment.User != null)
            {
                XML.Element.Attribute("UserID", Environment.User.ID);
            }
            if (Environment.SessionManager != null && Environment.SessionManager.Current != null)
            {
                XML.Element.Attribute("SessionUID", Environment.SessionManager.Current.UID);
            }
            string _eduFarma = BLVariableRepository.GetString(BL.Dictionary.Config.eduFarma.GameAddress, BL.Dictionary.Clients.PlugIn, String.Empty);
            if (!string.IsNullOrEmpty(_eduFarma))
            {
                XML.Element.Attribute("eduFarmaAddress", _eduFarma);
            }
            string _eduFarmaAdmin = BLVariableRepository.GetString(BL.Dictionary.Config.eduFarma.AdminAddress, BL.Dictionary.Clients.PlugIn, String.Empty);
            if (!string.IsNullOrEmpty(_eduFarmaAdmin))
            {
                XML.Element.Attribute("eduFarmaAdminAddress", _eduFarmaAdmin);
            }
            XML.Element.End();
            #endregion

            if (WebPageEngine.IsUserAuthorized)
            {
                if (_adminPanelDictionary.ContainsKey(AdministrationArea))
                {
                    _adminPanelDictionary[AdministrationArea].Load();
                }
            }
        }
    }
}